#!/usr/bin/perl -w

#
# Simple Voting System
# results.cgi - Counts the votes and displays the results
#
# 0.1	Markku Reunanen		28.11.1999
#

require 'perl/config.pl';
require 'perl/error.pl';
require 'perl/compo.pl';

# These arrays hold the information about all compos 
$bg_color = "white";	# Color for default messages 
$fg_color = "black";	# - " - 
$compos = 0;  		# Number of compos 
$points = "";		# Point information
@compo_info = ();       # Information about compos

# Try to get the configuration 
unless(conf_get($compos, $points, \@compo_info, $fg_color, $bg_color)) 
{
	error_message(ERROR_CONFIG(), $fg_color, $bg_color);
	exit 0;
} 

# Points according to voted place
@pos_points = split(/ /, $points);

# These arrays hold the information about all compos
@entries = ();		# Entries in all compos
@num_entries = ();	# Number of entries in each compo
@names = ();		# Names of the compos

# Open the compo files and get compo names, entries and their amounts
unless(compo_get(\@compo_info, \@entries, \@num_entries, \@names))
{
	error_message(ERROR_CONFIG(), $fg_color, $bg_color);
	exit 0;
}

# Lock the database for reading
unless(mkdir("svs.lock", 0))
{
	error_message(ERROR_LOCK(), $fg_color, $bg_color);
	exit 0;
}

# Read the compo results from svs.votes
unless(open(VOTEFILE, "svs.votes"))
{
	rmdir("svs.lock");
	error_message(ERROR_FILE(), $fg_color, $bg_color);
	exit 0;
}

# Read the votes and unlock database
@vote_rows = <VOTEFILE>;
chop @vote_rows; # Remove trailing newlines
close(VOTEFILE);
rmdir("svs.lock");

# Calculate indexes for the compos
@compo_index = ();
for($index = 0, $n = 0 ; $n < $compos ; $n++)
{
	$compo_index[$n] = $index;
	$index += $num_entries[$n];
}

# Clear the points to 0
for($n = 0 ; $n < $index ; $n++)
{
	$results[$n] = 0;
}

# Go through the votes and add points
foreach $vote (@vote_rows)
{
	# Erase the name field
	$vote =~ s/^.+://;
	# Extract compo, place and entry number
	($cur_compo, $cur_place, $cur_number) = split (/ /, $vote);

	# If this is a true vote let's add points
	if($cur_number)
	{
		$results[$compo_index[$cur_compo]+$cur_number-1] += $pos_points[$cur_place-1];
	}
}

# Content-type and HTML header
print "Content-type: text/html\n\n";
print "	<html>
        <title>SVS results</title>
	<body text=$fg_color bgcolor=$bg_color>
	<center>
	<hr>
	<h2>The results</h2>
	</center>";

# Sort the results and print them
for($compo = 0 ; $compo < $compos ; $compo++)
{
	# HTML: Separator and compo name
	print "<hr><h3>$names[$compo]</h3>\n";

	@entry_points = (); # The entry points go here
	
	# Collect all the entry points
	for($n = 0 ; $n < $num_entries[$compo] ; $n++)
	{
		push(@entry_points, $results[$compo_index[$compo]+$n]);
	}
	push(@entry_points, -1); # Plus a trailing -1

	# Sort the entry points
	@ordered = sort {$b <=> $a} @entry_points;

	# Go through the entries and print their place, name and points
	for($n = 0, $place=1 ; $n < $num_entries[$compo] ; $n++)
	{
		# Find the entry by its points
		for($i = 0 ; $i < $num_entries[$compo] ; $i++)
		{
			# Entry found. Mark its points to -1 to prevent
			# further matching. print HTML
			if($ordered[$n] == $entry_points[$i])
			{
				print "$place. $entries[$compo_index[$compo]+$i] ($ordered[$n] pts.)<br>\n";
				$entry_points[$i] = -1;
				$i = $num_entries[$compo]; # Break out of for()
			}
		}

		# Two entries with same points share the same place, so we'll
		# update the place only if the next entry has different points
		if($ordered[$n] != $ordered[$n+1])
		{
			$place = $n+2;
		}
	}
}

# HTML ends
print "</body></html>";

# Succesful exit
exit 1;

# EOS
