#
# Simple Voting System
# config.pl - Reads in the configuration data from svs.conf
#
# 0.2   Markku Reunanen         26.11.1999
# 0.3   Markku Reunanen         27.11.1999
# - Added point information
#

# The number of keywords required from a configuration file
use constant CONF_KEYWORDS => 4;

# Reads the configuration file
# $_[0] = Number of compos
# $_[1] = Point information
# $_[2] = Reference to compo information array
# $_[3] = Foreground color
# $_[4] = Background color
# Returns 0 on error, 1 on success
sub conf_get
{	
	my @conf_rows = ();
	my $option;
	my $value;
	my $found = 0;
	my $compo_found = 0;

	# Try to open the file
	unless(open(CONFFILE, "svs.conf"))
	{
		return 0;
	}
	
	@conf_rows = <CONFFILE>;
	close(CONFFILE);
	
	# Scan through the lines to find config keywords
	foreach $_ (@conf_rows)
	{
		# Remove starting, tailing and double blanks
		s/(^\s+)|(\s+\n)|(\s+$)|(\s\s+)//g;
		# Remove blanks from either side of ':'
		s/(:\s+)|(\s+:)/:/g;

		# Split row to option and value if string is non-empty
		if($_)
		{
			($option, $value) = split(/:/,$_,2);
		}
		else
		{
			$option = "";
			$value = "";
		}

		# Compo point information
		if($option eq "points")
		{
			$_[1] = $value;
			$found++;
		}

		# Compo description filenames
		if($option eq "compo")
		{
			# Update found options only for the first compo
			unless($compo_found)
			{
				$found++;
			}
			$compo_found++;
			
			$_ = $_[2];	
			push(@$_, $value);
		}

		# Foreground color option
		if($option eq "fgcolor")
		{
			$_[3] = $value;
			$found++;
		}

		# Background color option
		if($option eq "bgcolor")
		{
			$_[4] = $value;
			$found++;
		}
	}

	$_[0] = $compo_found;
	if($found != CONF_KEYWORDS())
	{
		0;	# Broken config file
	}
	else
	{
		1;	# Success!		
	}
}

1;

# EOS
