#
# Simple Voting System
# compo.pl - Reads in the compo data
#
# 0.1   Markku Reunanen         26.11.1999
#

# Reads the compo files
# $_[0] = Reference to filename array (caller fills this one)
# $_[1] = Reference to entry array
# $_[2] = Reference to number of entries array
# $_[3] = Reference to compo name array
# Returns 0 on error, 1 on success
sub compo_get
{	
	my $filenames =   $_[0];
	my $entries = 	  $_[1];
	my $num_entries = $_[2];
	my $names =       $_[3];
	my @compo_rows = ();
	my $count = 0;

	# Scan through the compo files
	foreach $_ (@$filenames)
	{
		# Try to open the file
		unless(open(COMPO, $_))
		{
			return 0;
		}

		# Read the compo file
		@compo_rows = <COMPO>;
		close(COMPO);
	
		# Add compo names to the corresponding array
		$_ = $compo_rows[0];
		s/\n//g; # Strip tailing \n
		push(@$names, $_);

		# Scan through the rows
		$count = 0;
		foreach $_ (@compo_rows)
		{
			# Strip tails
			s/(\n)|(\s+\n)//g;
			
			# If non-empty row, add compo to database
			if($_)
			{
				# Skip the first row (name), otherwise
				# add entry to the list
				if($count)
				{
					push(@$entries, $_);
				}
				$count++;
			}
		}

		# Check if there were any lines and add the number of
		# entries to the corresponding list
		if($count)
		{
			push(@$num_entries, $count-1);
		}
		else # Otherwise the compo file was broken
		{
			return 0;
		}
	}

	1; # Success!
}

1;

# EOS
