#!/usr/bin/perl -w

#
# Simple Voting System
# index.cgi - parses svs.html
#
# 0.1	Markku Reunanen		26.11.1999
# 0.2	Markku Reunanen		27.11.1999
# - More specific error messages
#

require 'perl/config.pl';
require 'perl/compo.pl';
require 'perl/error.pl';

# Predefine some values if not found in svs.conf file
$bg_color = "white";	# Color for default messages
$fg_color = "black";	# - " -
$compos = 0;		# Number of compos
$points = "";		# 
@compo_info = ();	# Information about compos

# Try to get the configuration
unless(conf_get($compos, $points, \@compo_info, $fg_color, $bg_color))
{
	error_message(ERROR_CONFIG(), $fg_color, $bg_color);
	exit 0;
}

# These arrays hold the information about all compos
@entries = ();		# Entries in all compos
@num_entries = ();	# Number of entries in each compo
@names = ();		# Names of the compos

# Open the compo files and get compo names, entries and their amounts
unless(compo_get(\@compo_info, \@entries, \@num_entries, \@names))
{
	error_message(ERROR_CONFIG(), $fg_color, $bg_color);
	exit 0;
}

# Open the main HTML
unless(open(MAINHTML, "html/svs.html"))
{
	error_message(ERROR_FILE(), $fg_color, $bg_color);
	exit(0);
}

@html_rows = <MAINHTML>;
close(MAINHTML);

# Print Content-type 
print "Content-type: text/html\n\n";

$current_compo = -1;	# Current compo number, -1 means there's none
$current_entry = 0;	# Current entry number in the main list
$current_place = 1;	# Current place the user can vote (1st, 2nd etc.)

# Scan through the HTML and insert compo names and entries
foreach $_ (@html_rows)
{
	# SVS:COMPO tag found, replace it with a compo name
	if(/<!--SVS:COMPO-->/)
	{
		$current_place = 1; # Start places from 1
		$current_compo++; # Advance to next one
		s/<!--SVS:COMPO-->/$names[$current_compo]/g;

		# Advance the main list entry counter
		if($current_compo)
		{
			$current_entry += $num_entries[$current_compo-1];
		}
	}

	# SVS:ENTRIES tag found, replace it with compo entries
	if(/<!--SVS:ENTRIES-->/)
	{
		# Something's very wrong here! SVS:ENTRIES before SVS:COMPO
		if($current_compo < 0)
		{
			$current_compo = 0; # We'll do what we can...
		}

		# Start the <selection> tag. Selection name consists of
		# the compo number, word "compo" and the place number
		# The first choice is blank
		$subst = "<select name=".$current_compo."compo".$current_place.">\n";
		$subst .= "<option value=0 selected>---No change---\n";
		$current_place++; # Next place

		# Make an <option> tag for all the entries with the entry
		# number starting from 1
		$counter = $current_entry;
		for($n = 1 ; $n <= $num_entries[$current_compo] ; $n++)
		{
			$subst .= "<option value=$n>$entries[$counter]\n";
			$counter++;
		}

		$subst .= "</select>\n"; # End of <selection>

		# Substitute SVS-tag with our <select> list
		s/<!--SVS:ENTRIES-->/$subst/g;
	}

	print; # Print the whole parsed HTML line
}

# Succesful exit!
exit 1; 

# EOS
