;
; The Ultimate Lieves!Tuore Music Player
; for MSX computers
;
;   version 1.01
;
; Song: "Sukka Sukka" by Yzi, July 1997
;
;
; coded by Yzi/L!T  2-8th April 1997
;
;   Copyright (c) Yrjo Fager 1997
;      E-mail: yrmafa@utu.fi
;
;
; English fix & clean-up 12th August 1997
;
;
; "This is one of these funny projects hmm."
;                            -Marq
;
; features:
;       - 3 channels
;       - adsr -envelopes
;       - 16 instruments
;             - adsr, volume, arpeggio, noise/tone, slide
;       - over 5 octaves (64 notes)
;       - tracks and patterns
;       - small
;       - commands & misc.
;             - slide up&down
;             - delay
;             - portamento
;             - vibrato
;             - track loop
;             - tempo
;       - developed with fMSX emulator
;       - my very first Z80 program
;             - probably a lot of interesting code
;
; future improvements:
;       - PSG envelopes
;

;----------offsets to channel parameters
#DEFINE CHN_INSTRUMENT  0
#DEFINE CHN_SONGPTR     2
#DEFINE CHN_PATTERNPTR  4
#DEFINE CHN_FINE        6
#DEFINE CHN_COARSE      7
#DEFINE CHN_TARGET_FINE 8
#DEFINE CHN_TARGET_COARSE 9
#DEFINE CHN_LEVEL       10
;in which part of ADSR we're going
#DEFINE CHN_ADSR        11
#DEFINE CHN_ARPIDX      12
#DEFINE CHN_TEMPO       13
#DEFINE CHN_DELAY       14
#DEFINE CHN_STOPPED     15
#DEFINE CHN_NOTE        16
; delta tuning
#DEFINE CHN_DELTA_FINE  17
#DEFINE CHN_DELTA_COARSE 18
#DEFINE CHN_VIBIDX      19
#DEFINE CHN_VIBSPD      20
; the loop point
#DEFINE CHN_REPEAT      21
#DEFINE CHN_REPEAT_PTR  22
; pointer to tunings table
; (if I implement a transpose command in the future)
#DEFINE CHN_NOTE_TABLE  24
#DEFINE CHN_SLIDE_FINE  26
#DEFINE CHN_SLIDE_COARSE 27

;-------offsets to instrument parameters
#DEFINE INS_LEVEL       0
#DEFINE INS_ATTACK      1
#DEFINE INS_DECAY       2
#DEFINE INS_SUSTAIN     3
#DEFINE INS_RELEASE     4
#DEFINE INS_MODE        5
; the upper four bits of arplen is the upper four bits of slide
#DEFINE INS_ARPLEN      6
#DEFINE INS_SLIDE       7
#DEFINE INS_NOISE_SLIDE 8
#DEFINE INS_ARPEGGIO    9

; commands in song order
#DEFINE TRACK_STOP      255
#DEFINE TRACK_SETREPEAT 254
#DEFINE TRACK_REPEAT    253

#DEFINE LASTPATT        ((lastp-pattern_addr)/2)

; command names
#include "commands.inc"

; ------------------ EXECUTION STARTS HERE! ------------------

.org	100h

        di                      ;       set our own handler
        ld      hl,handu
        ld      (38h+1),hl
        ld      a,0c3h
        ld      (38h),a
	ei

jam:    jp      jam

; ******* variables *********
channel         .db     0  ; channel number (0-2)
save_hl         .dw     0
chn_insptr      .dw     instruments
tempword        .dw     0
tempword2       .dw     0


; ------------ the tuning table -----------
#include "msxfreq.inc"


; ------------------- **** some procedures **** -------------------


; copied from portar-doc
vdp_write:
        out     (099h),a        ; Send data (note: the data is send FIRST)
        ld      a,b             ; Get the VDP register in [a]
        or      10000000b       ; Set bit 7 to indicate register WRITE
        out     (099h),a        ; Select register
        ret

; ---------- CLEAR ----------
; ACCUMULATOR HAS TO BE ZERO!!!!!!!!!!
clear_everything:
        ld      (ix+CHN_ADSR), a
        ld      (ix+CHN_LEVEL), a
        ld      (ix+CHN_ARPIDX), a
        ld      (ix+CHN_VIBIDX), a
        ld      (ix+CHN_VIBSPD), a
clear_delta_and_slide:
        ld      (ix+CHN_DELTA_FINE), a
        ld      (ix+CHN_DELTA_COARSE), a
        ld      (ix+CHN_SLIDE_FINE), a
        ld      (ix+CHN_SLIDE_COARSE), a
        ret

; ----------- SET CHANNEL VOLUME -------------
; sets volume [a] on channel [channel]
; volume is 4.4 bit fixed point number
;
; destroys registers a, b
set_channel_volume:
        ld      b, a
        ld      a, (channel)     ; PSG reg. 8-10: volume ch. 0-2
	add	a, 8
	out	(0A0h), a
	ld	a, b
	srl	a
	srl	a
	srl	a
        srl     a               ; take the 4 upper bits
	out	(0A1h), a
	ret

; ----------- SET CHANNEL TUNING -------------
; sets [channel]
; frequency [b,c]  b=coarse, c=fine
;
; destroys a, d
set_channel_tuning:
        ld      a, (channel)     ; PSG reg. 0-5: tuning ch. 0-2
        sla     a               ; a=channel*2
        ld      d, a            ; channel*2 talteen
        out     (0A0h), a       ; fine freq.
	ld	a, c
	out	(0A1h), a
	ld	a, d
        inc     a               ; a=channel*2+1
	out	(0A0h), a	; coarse, PSG reg (ch+1)
	ld	a, b
	out	(0A1h), a
	ret

; --- iy := 2 * accumulator
iy_2a: ; just a little routine...
        sla     a       ; multiply by two (there's 16 bits/tuning)
        ld      (tempword), a
        sub     a
        ld      (tempword+1), a
        ld      iy, (tempword)
        ret

; ---------- ADD_VIBRATO_FREQUENCY ---------------
; adds vibrato frequency to  bc
; destroy a, b, c, iy
add_vibrato_frequency:
        ld      a, (ix+CHN_VIBSPD)
        cp      0
        jp      z, vibrato_is_not_on_now
        ld      a, (ix+CHN_VIBIDX)
        call    iy_2a ; iy := 2 * a
        ld      de, vibrato_table
        add     iy, de          ;iy=offset vibrato_table + vibidx * 2
        ld      a, c
        add     a, (iy)
        ld      c, a
        ld      a, b
        adc     a, (iy+1)
        ld      b, a
vibrato_is_not_on_now:
        ret
; end - add_vibrato_frequency      ---- destroys iy!

; ---------- GET NOTE FREQUENCY ---------------
; gets the frequency of the note in accumulator to bc
; destroys a, b, c, iy
get_note_frequency:
        call    iy_2a  ; iy := 2 * a
        ;haetaan tuning-taulukosta oikeat arvot
        ld      bc, tunings
        add     iy, bc          ;iy=offset tunings + note * 2
        ld      a, (iy)         ;bc=tuning (12 bit)
        add     a, (ix+CHN_DELTA_FINE)
        ld      c, a
        ld      a, (iy+1)
        adc     a, (ix+CHN_DELTA_COARSE)
        ld      b, a
        ret
; end - get_note_frequency         ---- destroys iy!

; ----------- SET NOTE -------------------
; sets the frequency of the note in accumulator to
; current channel
; destroys a, b, c, d, iy
set_note:
        call    get_note_frequency ; tuhoaa iy:n
        call    add_vibrato_frequency ; kuten mys...
        call    set_channel_tuning
        ret
; end - set_note

; -------------- SET CHANNEL INSTRUMENT ---------------
; sets instrument in a to current channel (the number is in
; the UPPER FOUR BITS of accumulator)
; IX points to start of channel parameters
; sets HL and IY to the instrument
set_channel_instrument:
        ld      c, a
        ld      b, 0
        ld      hl, instruments
        add     hl, bc  ; hl now points to current instrument
        ld      (ix), l
        ld      (ix+1), h
        ld      (chn_insptr), hl
        ld      iy, (chn_insptr)

        ; clear channel parameters
        sub     a ; a := 0
        call    clear_everything

; noise/tone enable?
        ld      a, (iy+INS_MODE)
        ld      b, 9    ; b = mask
        and     b
        ld      c, a    ; c = noise&tone enable

        ld      a, 7 ; mixer
        out     (0A0h), a

        ld      a, (channel)
        cp      0
        jp      z, ouagadougou
        sla     c
        sla     b
        cp      1
        jp      z, ouagadougou
        sla     c
        sla     b
ouagadougou:
        ld      a, b
        xor     255
        ld      b, a
        in      a, (0A2h)
        and     b
        xor     c

        out     (0A1h), a

        ret
; end - set_channel_instrument

update_adsr:
; --------------- UPDATE ADSR ------------------
; IX:channel
; IY:instrument
        ld      a, (ix+CHN_ADSR)
        cp      0
        jp      nz, not_attack
; ---------- attack-vaihe --------------
        ld      a, (ix+CHN_LEVEL)
        add     a, (iy+INS_ATTACK) ;overflow?
        jp      nc, n1ce
        ld      a, (iy+INS_LEVEL) ;yes - set correct level.
        inc     (ix+CHN_ADSR)
        jp      ookkei
n1ce:   cp      (iy+INS_LEVEL) ;ins_level greater than accumulator(=chn_level)?
        jp      c, ookkei
        ;accumulator is greater - set ins_level and proceed with adsr
        ld      a, (iy+INS_LEVEL)
        inc     (ix+CHN_ADSR)
        jp      ookkei
not_attack:
        cp      1 ; onko CHN_ADSR 1?
        jp      nz, not_decay
; ---------- decay-phase ---------------
        ld      a, (ix+CHN_LEVEL)
        sub     (iy+INS_DECAY)
        jp      nc, n1ce2 ; did it go below zero?
        ld      a, (iy+INS_SUSTAIN)
        inc     (ix+CHN_ADSR)
        jp      ookkei
n1ce2:  cp      (iy+INS_SUSTAIN)
        jp      nc, ookkei ; is ins_sustain less than chn_level?
        ; it went too high - set ins_sustain and proceed adsr
        ld      a, (iy+INS_SUSTAIN)
        inc     (ix+CHN_ADSR)
        jp      ookkei
not_decay:
        cp      2 ; onko CHN_ADSR 2?
        jp      nz, not_sustain
; --- sustain-phase (do nothing) --
        ret
not_sustain:
        cp      3 ; onko CHN_ADSR 3? (release)
        jp      nz, not_release
; release-phase (decrease level to zero)
        ld      a, (ix+CHN_LEVEL)
        sub     (iy+INS_RELEASE)
        jp      nc, ookkei ; did it overflow?
        sub     a ; overflow, a:=0
        inc     (ix+CHN_ADSR) ; forwards, CHN_ADSR := 4  (end)
        jp      ookkei
not_release: ; end of adsr, do nothing
        ret
ookkei: ld      (ix+CHN_LEVEL), a
        call    set_channel_volume
        ret

; end - update_adsr

; ------ UPDATE ARPEGGIO ---------------
; Goes forward with arpeggio and sets
; the correct note for the channel.
; destroys  a, b, c, d, hl, iy
update_arpeggio:
        ld      a, (ix+CHN_ARPIDX)
        inc     a
        cp      (iy+INS_ARPLEN)
        jp      nz, ohi_tuskaista
        sub     a
ohi_tuskaista:
        ld      (ix+CHN_ARPIDX), a

        ld      c, a
        sub     a
        ld      b, a    ; bc = offset to ins_arpeggio table

        add     iy, bc
        ld      a, (ix+CHN_NOTE)
        add     a, (iy+INS_ARPEGGIO)
        call    set_note ; destroys iy !
        ret
; end - update_arpeggio      DESTROYS IY !!!


; ------ UPDATE INS SLIDE -------------------
; destroys a, b, c, hl
update_ins_slide:
        ld      a, (iy+INS_SLIDE)
        cp      0
        jp      z, no_ins_slide
        ld      l, (ix+CHN_DELTA_FINE)
        ld      h, (ix+CHN_DELTA_COARSE)
        ld      c, a
; I thought that somebody would want 12 bit slides
#ifdef SLIDE_12BIT
        ld      b, (iy+INS_ARPLEN)
        sra     b
        sra     b
        sra     b
        sra     b
#else
        sub     a
        ld      b, a
#endif
        add     hl, bc
        ld      (ix+CHN_DELTA_FINE), l
        ld      (ix+CHN_DELTA_COARSE), h        ; delta_tuning += ins_slide
no_ins_slide:
        ret
; end - update_ins_slide

; ------ UPDATE SLIDE -------------------
; destroys a, b, c, hl
update_slide:
        ld      a, (ix+CHN_SLIDE_FINE)
        cp      0
        jp      z, ei_mitaan_slidea
        ld      l, (ix+CHN_DELTA_FINE)
        ld      h, (ix+CHN_DELTA_COARSE)
        ld      c, a
        ld      b, (ix+CHN_SLIDE_COARSE)
        add     hl, bc
        ld      (ix+CHN_DELTA_FINE), l
        ld      (ix+CHN_DELTA_COARSE), h        ; delta_tuning += chn_slide
ei_mitaan_slidea:
        ret
; end - update slide


; ------------ UPDATE VIBRATO -----------------
; destroys a
update_vibrato:
        ld      a, (ix+CHN_VIBIDX)      ; vibidx = (vibidx+vibspd) AND 63
        add     a, (ix+CHN_VIBSPD)
        and     63
        ld      (ix+CHN_VIBIDX), a
        ret


#include "mul4.inc"

next_byte: ; increases hl and sets a new value to (ix+CHN_PATTERNPTR)
        inc     hl
        ld      (ix+CHN_PATTERNPTR), l
        ld      (ix+CHN_PATTERNPTR+1), h
        ret

song_next_byte:
        inc     hl ; next pattern, please!
        ld      (ix+CHN_SONGPTR), l
        ld      (ix+CHN_SONGPTR+1), h
        ret

; ---------- SET DELAY
; sets the delay in accumulator
; CHN_DELAY = CHN_TEMPO * a
; destroys a, b, c
set_delay:
        and     15
        ld      c, a
        ld      b, (ix+CHN_TEMPO)
        call    mul4
        ld      (ix+CHN_DELAY), a
        ret

; --------------------------------------------------------------------------
; ---------------- PROCESS CHANNEL -----------------------------------------
; --------------------------------------------------------------------------
; IX points to channel parameters
; destroys all registers
process_channel:
        ld      a, (ix+CHN_STOPPED)
        cp      1
        jp      nz, im_still_standing_yeah_yeah_yeah
        ret
im_still_standing_yeah_yeah_yeah:

; let's read the current instrument pointer to iy
        ld      l, (ix)         ; iy := (ix+0) (channel's instrument)
        ld      h, (ix+1)
        ld      (chn_insptr), hl   ; save it
        ld      iy, (chn_insptr)

; decrease delay, and if not zero, wait
        dec     (ix+CHN_DELAY)
        jp      nz, lets_wait

; no more delay -> go on
to_be_continued:
        ld      iy, (chn_insptr)   ; note! set_instr sets this also
        ld      l, (ix+CHN_PATTERNPTR)    ; patternpointer from channel
        ld      h, (ix+CHN_PATTERNPTR+1)  ; parameters
        ld      a, (hl) ; read the command
        ld      c, a    ; put it even to register c
        and     192     ; take bitis 6 and 7
        cp      0       ; look at two upper bits
        jp      z, it_is_note
        cp      64
        jp      z, it_is_portamento
        cp      128
        jp      z, it_is_tempo
        cp      192
        jp      z, it_is_command
        ; no other alternatives

lets_wait: ; --- CHN_DELAY was > 0 ---
        call    update_vibrato
        call    update_ins_slide
        call    update_slide
        call    update_arpeggio ; destroys iy!
waitywait: ; we come here from tick 0 also, ie. arpeggio is not updated
          ; at tick 0, but adsr is (to prevent from getting a silent moment)
        ld      iy, (chn_insptr)
        call    update_adsr
        ret     ; return from process_channel !!

lets_see_now: ; ----- the command has now been processed ----
        ; not finished until CHN_DELAY > 0
        ld      a, (ix+CHN_DELAY)
        cp      0
        jp      z, to_be_continued   ; if CHN_DELAY = 0, jump
        jp      waitywait ; otherweise wait

; -------- UUSI NUOTTI -------
it_is_note: ; two highest bits 00
        ld      a, c    ; note number is in accumulator
        ld      (ix+CHN_NOTE), a        ; save note for arpeggio

        call    next_byte   ;hl+=1
        ld      a, (hl)
        ld      (save_hl), hl   ; set_channel_instrument destroys hl
        and     240     ; four highest bits = instrument
        ; acc. doesn't need to be shifted
        call    set_channel_instrument
        ld      hl, (save_hl)

note_set: ; we may jump here from portamento command
        ld      a, (hl)
        and     15      ; 4 lower bits = delay
        call    set_delay

        ; the note has to be set after instrument, because
        ; we need the instrument info there
        ld      a, (ix+CHN_NOTE)
        call    set_note
        ; iy is now destroyed

        call    next_byte ; after processing hl points to a new byte
        jp      lets_see_now
; ----------- TEMPO ----------
it_is_tempo:
        ld      a, c
        and     15   ; tempo is only 4 bits, because I'm lazy
        ld      (ix+CHN_TEMPO), a
        call    next_byte
        jp      lets_see_now
; -------- PORTAMENTO --------
it_is_portamento: ; just a simple portamento
                  ; sets note but not instrument
        ld      a, c
        and     63
        ld      (ix+CHN_NOTE), a
        sub     a
        call    clear_delta_and_slide
        call    next_byte
        jp      note_set

; ---------- KOMENTO ---------
it_is_command: ; the command is a command, hmm...
        ld      a, c
        cp      END_PATTERN
        jp      z, end_pattern
        cp      NOTE_OFF
        jp      z, do_note_off
        cp      DELAY
        jp      z, do_delay
        cp      VIBRATO
        jp      z, do_vibrato
        cp      SLIDE_UP
        jp      z, do_slide_up
        cp      SLIDE_DOWN
        jp      z, do_slide_down
it_has_been_dealt_with: ; <--- we come here from the command processing <---
        call    next_byte
        jp      lets_see_now

end_pattern:
        ld      l, (ix+CHN_SONGPTR)
        ld      h, (ix+CHN_SONGPTR+1)
        ; hl points to pattern list
track_to_be_continued:
        call    song_next_byte
        ld      d, 0
        ld      e, (hl)
        ld      a, e    ; is it a song order commang
        cp      TRACK_STOP
        jp      z, end_of_the_world
        cp      TRACK_SETREPEAT
        jp      z, trak_set_repeat
        cp      TRACK_REPEAT
        jp      z, trak_repeat

        ; it wasn't a song order command, so it is a pattern numbre
        sla     e       ; de=pattern number * 2

        ld      iy, pattern_addr
        add     iy, de  ; iy -> pattern_addr[pnumero*2]

        ld      l, (iy)
        ld      h, (iy+1)       ; hl points to new pattern
        ld      (ix+CHN_PATTERNPTR), l
        ld      (ix+CHN_PATTERNPTR+1), h

; This is importand here:
        dec     hl

        jp      it_has_been_dealt_with

do_note_off: ; ----- NOTE OFF --------

        ld      (ix+CHN_ADSR), 3 ; set chn_adsr := 3 (release)
do_delay:
        inc     hl      ; next byte: note off delay
        ld      a, (hl)
        and     15
        call    set_delay
        jp      it_has_been_dealt_with

do_vibrato: ; ------ VIBRATO -------
        inc     hl
        ld      a, (hl)
        ld      (ix+CHN_VIBSPD), a
        jp      it_has_been_dealt_with

do_slide_up: ; ------- SLIDE UP -------
        inc     hl
        ld      a, (hl)
        neg
        ld      (ix+CHN_SLIDE_FINE), a
        ld      a, 255
        ld      (ix+CHN_SLIDE_COARSE), a
        jp      do_delay
do_slide_down: ; ------ SLIDE DOWN ------
        inc     hl
        ld      a, (hl)
        ld      (ix+CHN_SLIDE_FINE), a
        sub     a
        ld      (ix+CHN_SLIDE_COARSE), a
        jp      do_delay

; ------------- song order commands: ----------------------------

end_of_the_world: ; ---------- track ended
                ; we come here, when there is a TRACK_STOP
                ; in the song list. now we stop playing and
                ; set CHN_STOPPED := 1
        ld      a, 1
        ld      (ix+CHN_STOPPED), a
        ret

trak_set_repeat:
; save value of HL for repeat.
; after this we continue with playing the patterns
        ld      (ix+CHN_REPEAT_PTR), l
        ld      (ix+CHN_REPEAT_PTR+1), h
        jp      track_to_be_continued

trak_repeat: ; now we have to jump backwards in the song order
        ld      a, (ix+CHN_REPEAT)
        cp      0
        jp      nz, decrement
        ; CHN_REPEAT = 0 : start loop
        inc     hl
        ld      a, (hl)
        jp      song_order_jump
decrement: ; CHN_REPEAT was not zero
        cp      255 ; repeat 255: infinite repeat
        jp      z, song_order_jump
        dec     a
        jp      z, repeat_over  ; CHN_REPEAT oli 1 : let's go forwards
        ; CHN_REPEAT oli >1 : do a jump in song order
song_order_jump:
        ld      (ix+CHN_REPEAT), a
        ld      l, (ix+CHN_REPEAT_PTR)  ; jump: get a new value for hl
        ld      h, (ix+CHN_REPEAT_PTR+1)
;        inc     hl
        jp      track_to_be_continued

repeat_over:
        ld      (ix+CHN_REPEAT), a ; accumulator is zero
        inc     hl ; skip the repeat parameter
        jp      track_to_be_continued



; ---------------------------------------- o,o ------------- HANDLER ------
;                                          -=-
; ***** Interrupt handler *****

handu:  PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        PUSH    IX
        PUSH    IY

        in      a,(99h)         ;       ACKnowledge?

	ld	a,087h
	out	(099h),a
	ld	a,034h
	out	(099h),a

        sub     a
        ld      (channel), a
        ld      ix, channel_0_parameters
        call    process_channel

        ld      a, 1
        ld      (channel), a
        ld      ix, channel_1_parameters
        call    process_channel

        ld      a, 2
        ld      (channel), a
        ld      ix, channel_2_parameters
        call    process_channel


        ld      a,087h
	out	(099h),a
	ld	a,00
	out	(099h),a

        POP     IY
        POP     IX
        POP     HL
        POP     DE
        POP     BC
        POP     AF

	ei
	reti


; INSTRUMENT FORMAT:
;   LVL, ATT, DCY, STN, RLS, MDE, 4SLDHI:4ARL, SLD, NSD, AR0, AR1, AR2,..,AR6
;

instruments:   ; 16*16 = 256 bytes
.db 0F0h,0FFh,00Ah,080h,050h,008h,001h,000h,000h,0,0,0,0,0,0,0 ; i 0, basso
.db 0C8h,090h,024h,040h,008h,008h,002h,000h,000h,0,12,0,0,0,0,0 ; i 1, melodia
.db 0A0h,040h,001h,000h,00Ah,008h,003h,000h,000h,0,7,12,0,0,0,0 ; i 2, kvintti
.db 0A0h,040h,002h,000h,00Ah,008h,003h,000h,000h,0,3,7,0,0,0,0 ; i 3, molli
.db 0A0h,040h,002h,000h,00Ah,008h,003h,000h,000h,0,3,8,0,0,0,0 ; i 4, duuri/3
.db 0A0h,040h,002h,000h,00Ah,008h,003h,000h,000h,0,5,9,0,0,0,0 ; i 5, duuri/5
.db 0E0h,0F0h,014h,000h,040h,000h,002h,0F0h,000h,0,11,0,0,0,0,0 ; i 6, virveli
.db 090h,0F0h,034h,000h,040h,000h,001h,030h,000h,0,0,0,0,0,0,0 ; i 7, "rumpu"
.db 070h,0F0h,044h,000h,040h,000h,001h,030h,000h,0,0,0,0,0,0,0 ; i 8, "rumpu"
.db 0B0h,0F0h,009h,000h,040h,000h,001h,030h,000h,0,0,0,0,0,0,0 ; i 9, "haikka"
.db 0B0h,0FFh,00Ah,040h,050h,008h,001h,000h,000h,0,0,0,0,0,0,0 ; i A, pikkubas
.db 0A0h,080h,008h,000h,010h,008h,004h,000h,000h,0,3,7,12,0,0,0 ; i B, molli
.db 0A0h,080h,007h,000h,010h,008h,004h,000h,000h,0,4,5,9,0,0,0 ; i C, maj7/7
.db 0A0h,080h,007h,000h,010h,008h,004h,000h,000h,0,3,5,9,0,0,0 ; i D, 7/7
.db 0F0h,0A0h,00Ah,000h,010h,008h,001h,000h,000h,0,0,0,0,0,0,0 ; i E, basso 2
.db 0D8h,0F0h,080h,000h,010h,008h,003h,000h,000h,0,12,13,0,0,0,0 ; i F, click
; ---- that's all... ----

; Instrument explanation:
;
; LVL = level
; ATT = attack rate
; DCY = decay rate
; STN = sustain level
; RLS = release rate
; MDE = mode (8=sound, 1=noise, 0=sound+noise);
; SLDHI = slide hi (CHANGE THE DEFINE)
; ARL = arpeggio length
; SLD = slide
; NSD = noise slide (NOT IMPLEMENTED)
; AR0..AR6 = arpeggio notes


channel_0_parameters:
.dw instruments, track0-1, starting_pattern
.db 0,0,0,0,0,0,0,4 ; first offs. 6
.db 1,0,0,0,0,0,0,0 ; last offs. 21
.db 0,0,0,0,0,0,0,0 ; first 22
channel_1_parameters:
.dw instruments, track1-1, starting_pattern
.db 0,0,0,0,0,0,0,4
.db 1,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0
channel_2_parameters:
.dw instruments, track2-1, starting_pattern
.db 0,0,0,0,0,0,0,4
.db 1,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0


; ------------------------------- SONG ORDER ------------------------------

track0:  ; ------ bass+drum
.db TRACK_SETREPEAT, 0, TRACK_REPEAT, 6 ; intro
.db 1 ; intron filli
.db TRACK_SETREPEAT
.db 0, 2, 4, 0, 3, 0, 4, 5 ; a-osa
.db 0, 2, 4, 0, 3, 0, 4, 6
.db TRACK_REPEAT, 255
.db LASTPATT, TRACK_STOP

track1:  ; ------- arpeggio
.db 10, 11, 12, 13 ; intro
.db 10, 11, 12, 14
.db TRACK_SETREPEAT
.db 15, 18, 16, 15 ; a-osa
.db 15, 18, 16, 17
.db 15, 18, 16, 15
.db 15, 18, 16, 17
.db TRACK_REPEAT, 255
.db LASTPATT, TRACK_STOP

track2:  ; ------- melody
.db TRACK_SETREPEAT, 20, TRACK_REPEAT, 6
.db 21 ; koho
.db TRACK_SETREPEAT
.db 22,22,23,22,22
.db 23,23,24
.db 22,22,23,22,22
.db 23,23,24
.db 22,22,23,22,22
.db 23,22,22,24
.db 22,22,23,22,22
.db 24,24,22,24,24,22,24
.db 20,20,20,20,20,20,20,21
.db TRACK_REPEAT, 255
.db LASTPATT, TRACK_STOP


starting_pattern:
.db NOTE_OFF, 4
.db END_PATTERN

#include "commands.inc"

; drum notes
nSD .equ 35
nDR .equ 48
nHH .equ 40

; -------------------------------- PATTERNS! -------------------------------

patt00: ; ------------- PATTERN 00 ------------
        .db nE1,004h, nHH,092h, nE1,002h
        .db nSD,062h, nE2,002h, nDR,072h, nD1,002h
        .db nE1,004h, nHH,092h, nE1,002h
        .db nSD,062h, nG1,002h, nDR,072h, nA1,002h
        .db END_PATTERN
patt01: ; ------------- PATTERN 01 ------------
        .db nD1,004h, nHH,092h, nDR,072h
        .db nSD,062h, nDR,072h, nD1,002h, nE1,002h
        .db nDR,072h, nSD,062h, nHH,092h,
        .db nE1,002h, nHH,091h, NOTE_OFF,1, nE1,002h
        .db nSD,061h, NOTE_OFF,1,
        .db nSD-8,061h, NOTE_OFF,1,
        .db END_PATTERN
patt02: ; ------------- PATTERN 02 ------------ basso G
        .db nG1,004h, nHH,092h, nG1,002h
        .db nSD,062h, nG2,002h, nDR,072h, nG1,002h
        .db nG1,004h, nHH,092h, nG1,002h
        .db nSD,062h, nG1,002h, nDR,072h, nG1,002h
        .db END_PATTERN
patt03: ; ------------- PATTERN 03 ------------ basso C
        .db nC1,004h, nHH,092h, nC1,002h
        .db nSD,062h, nG1,002h, nDR,072h, nG1,002h
        .db nC1,004h, nHH,092h, nC1,002h
        .db nSD,062h, nC1,002h, nDR,072h, nC1,002h
        .db END_PATTERN
patt04: ;                                       basso A
        .db nA1,004h, nHH,092h, nA1,002h
        .db nSD,062h, nA1,002h, nDR,072h, nE1,002h
        .db nA1,004h, nHH,092h, nA1,002h
        .db nSD,062h, nA1,002h, nDR,072h, nA1,002h
        .db END_PATTERN
patt05: ;                                       basso D
        .db nD1,004h, nHH,092h, nA1,002h
        .db nSD,062h, nD1,002h, nDR,072h, nA1,002h
        .db nD1,004h, nHH,092h, nD1,002h
        .db nSD,062h, nD1,002h, nDR,072h, nD1,002h
        .db END_PATTERN
patt06: ; ---- alkufilli arpeggiot              basso D - E - F# - G
        .db nD1,004h, nHH,092h, nD1,002h
        .db nSD,062h, nE1,002h, nDR,072h, nE1,002h
        .db nFis1,004h, nHH,092h, nFis1,002h
        .db nSD,062h, nG1,002h, nDR,072h, nG1,002h
        .db END_PATTERN

patt07: ; ---- kova rumputus ----
        .db END_PATTERN
patt08: ; ---- kova bassotus ----
patt09: .db END_PATTERN
patt10: ; ---------- pattern 10 ------------- ARPEGGIOITA
        .db nE3,024h, NOTE_OFF,4
        .db nE3,024h, SLIDE_UP,1,2, PORTAMENTO+nG3,021h, NOTE_OFF,1
        .db nG3,024h, NOTE_OFF,2
        .db nG3,022h, NOTE_OFF,4
        .db nG3,022h, NOTE_OFF,2
        .db END_PATTERN
patt11:
        .db nG3,024h, NOTE_OFF,4
        .db nG3,024h, SLIDE_UP,1,2, PORTAMENTO+nA3,021h, NOTE_OFF,1
        .db nA3,024h, NOTE_OFF,2
        .db nA3,022h, NOTE_OFF,4
        .db nA3,022h, NOTE_OFF,2
        .db END_PATTERN
patt12:
        .db nA3,024h, NOTE_OFF,4
        .db nA3,024h, SLIDE_UP,1,2, PORTAMENTO+nC3,021h, NOTE_OFF,1
        .db nC3,024h, NOTE_OFF,2
        .db nC3,022h, NOTE_OFF,4
        .db nE3,022h, NOTE_OFF,2
        .db END_PATTERN
patt13:
        .db nD3,024h, NOTE_OFF,4
        .db nD3,024h, SLIDE_UP,1,2, PORTAMENTO+nE4,021h, NOTE_OFF,1
        .db nE4,024h, NOTE_OFF,2
        .db nE3,022h, NOTE_OFF,4
        .db nE3,022h, NOTE_OFF,2
        .db END_PATTERN
patt14: ; - intron filli
        .db nD3,024h, NOTE_OFF,4
        .db nD3,022h, SLIDE_UP,1,2, PORTAMENTO+nE4,021h, NOTE_OFF,1
        .db nE4,022h, NOTE_OFF,2, NOTE_OFF,14
        .db END_PATTERN
patt15: ; e-molli
        .db nE3,034h, NOTE_OFF,4
        .db nE3,034h, nE3,033h, NOTE_OFF,1
        .db nE3,034h, NOTE_OFF,2
        .db nE3,032h, NOTE_OFF,4
        .db nE3,032h, NOTE_OFF,2
        .db END_PATTERN
patt16: ; c-duuri /3
        .db nE3,044h, NOTE_OFF,4
        .db nE3,044h, nE3,043h, NOTE_OFF,1
        .db nE3,044h, NOTE_OFF,2
        .db nE3,042h, NOTE_OFF,4
        .db nE3,042h, NOTE_OFF,2
        .db END_PATTERN
patt17: ; d-duuri /3
        .db nFis3,044h, NOTE_OFF,4
        .db nFis3,044h, nFis3,043h, NOTE_OFF,1
        .db nFis3,044h, NOTE_OFF,2
        .db nFis3,042h, NOTE_OFF,4
        .db nFis3,042h, NOTE_OFF,2
        .db END_PATTERN
patt18: ; g-duuri /5
        .db nD3,054h, NOTE_OFF,4
        .db nD3,054h, nD3,053h, NOTE_OFF,1
        .db nD3,054h, NOTE_OFF,2
        .db nD3,052h, NOTE_OFF,4
        .db nD3,052h, NOTE_OFF,2
        .db END_PATTERN
patt19:
patt20: ; ---- melodiaa ----
        .db NOTE_OFF,8, NOTE_OFF,8, NOTE_OFF,8, NOTE_OFF,8
        .db END_PATTERN
patt21: ; ---- melodiaa ----
        .db NOTE_OFF,8, NOTE_OFF,8
        .db NOTE_OFF,6
        .db nB3,012h, nE4,012h, nE4,012h
        .db nD4,012h, nG4,012h
        .db END_PATTERN
patt22: .db nE4,012h, nD4,012h, nE4,012h, nG4,012h, NOTE_OFF,2
        .db END_PATTERN ; 5 * 2
patt23: .db nB4,012h, nE4,012h, nD4,012h, nB4,012h
        .db nE4,014h, nE4,014h, nE4,012h, nG4,012h, nG4,0F2h, NOTE_OFF,2
        .db END_PATTERN ; 12 * 2
patt24: .db nE4,012h, nD5,012h, nB4,012h, nB4,012h, nA4,012h, nA4,012h,
        .db END_PATTERN ; 6 * 2
patt25: .db nE5,068h
        .db END_PATTERN
patt26:
patt27:
patt28:
patt29:
lastpat: .db NOTE_OFF,8, END_PATTERN

pattern_addr:
.dw     patt00
.dw     patt01
.dw     patt02
.dw     patt03
.dw     patt04
.dw     patt05
.dw     patt06
.dw     patt07
.dw     patt08
.dw     patt09
.dw     patt10
.dw     patt11
.dw     patt12
.dw     patt13
.dw     patt14
.dw     patt15
.dw     patt16
.dw     patt17
.dw     patt18
.dw     patt19
.dw     patt20
.dw     patt21
.dw     patt22
.dw     patt23
.dw     patt24
.dw     patt25
;.dw     patt26
;.dw     patt27
;.dw     patt28
;.dw     patt29
lastp:
.dw     lastpat

vibrato_table: ; quite stupid, but it was easy to implement
.dw    0,24/64,49/64,74/64,97/64,120/64,141/64,161/64,
.dw    180/64,197/64,212/64,224/64,235/64,244/64,250/64,253/64
.dw    255/64,253/64,250/64,244/64,235/64,224/64,212/64,197/64
.dw    180/64,161/64,141/64,120/64,97/64,74/64,49/64,24/64
.dw    0,-24/64,-49/64,-74/64,-97/64,-120/64,-141/64,-161/64
.dw    -180/64,-197/64,-212/64,-224/64,-235/64
.dw    -244/64,-250/64,-253/64,-255/64,-253/64,-250/64
.dw    -244/64,-235/64,-224/64,-212/64,-197/64
.dw    -180/64,-161/64,-141/64,-120/64
.dw    -97/64,-74/64,-49/64,-24/64
;.dw    0,24,49,74,97,120,141,161,
;.dw    180,197,212,224,235,244,250,253
;.dw    255,253,250,244,235,224,212,197
;.dw    180,161,141,120,97,74,49,24
;.dw    0,-24,-49,-74,-97,-120,-141,-161
;.dw    -180,-197,-212,-224,-235
;.dw    -244,-250,-253,-255,-253,-250
;.dw    -244,-235,-224,-212,-197
;.dw    -180,-161,-141,-120
;.dw    -97,-74,-49,-24

.end
; LOP-BU


