#include <interrupt.h>
#include <msxlib.h>
#include "ArkosTrackerPlayer_MSX.h"

#define NUM_PARTS (16)

// Pics
extern unsigned char hospitaali[],pills[],mv[];

extern unsigned char *dang[];

// Palette
static unsigned char picpal[]={BLACK,GREEN,LIGHT_BLUE,CYAN,
                               RED,LIGHT_YELLOW,GREY,WHITE};

static unsigned char blokptn[]={   0x00,0x7e,0x7e,0x7e, 0x7e,0x7e,0x7e,0x00,
                                   0xff,0xff,0xff,0xe7, 0xe7,0xff,0xff,0xff,
                                   0xff,0x81,0x81,0x81, 0x81,0x81,0x81,0xff,
                                   0x00,0x00,0x00,0x18, 0x18,0x00,0x00,0x00 };

unsigned char buf1[768],buf2[768],texture[24*32],rantomi[768+256];

static char msx1[]={ // Approximate MSX1 palette
                0,0,0,
                3,6,3,
                4,7,4,
                3,3,6,
                4,4,7,

                6,2,2,
                4,7,7,
                7,3,3,
                7,4,4,
                6,5,2,

                6,6,3,
                1,5,1,
                6,3,6,
                6,6,6,
                7,7,7
                };

unsigned char lukaps[256*4],*lowbit,*colorcyc,*treeshold;

// Scroll image vertically
void pittaa(unsigned char *d,unsigned char *s,int offi)
{
    int n;

    s+=offi<<5;
    for(n=0;n<24;n++,d+=32,s+=32)
    {
        mem_cpy(d,s,32);
        offi++;
        if(offi==24)
            s-=32*24;
    }
}

void lukap(unsigned char *d,unsigned char *table);

// Rotate the four animation frames
void rotlowbits(unsigned char *d)
{
    lukap(d,lowbit);
}

// Rotate the four animation frames
void colorcycle(unsigned char *d)
{
    lukap(d,colorcyc);
}

void threshold(unsigned char *d)
{
    lukap(d,treeshold);
}

void kaleido(unsigned char *d);
void suumi(unsigned char *d,unsigned char *s,unsigned off);

extern unsigned char *hlinep,*vlinep;
void hline(int y,unsigned char c);
void vline(int x,unsigned char c);

void dodang(unsigned char *d,unsigned char **ptr);
void xor(void *d,void *s);
void and(void *d,void *s);
void or(void *d,void *s);

static volatile int part_tick = 0; // this resets to zero at the start of each part, and increments by 1 each tick i.e. vbi
static volatile char thump = 0; // this increments by 1 at the start of each musically relevant kick/hit/something. the music logic is coded in the interrupt routine
static volatile char mus_fftargetpart = 0; // fast forward target part
static volatile char mus_ffingtopart = 0; // are we fast forwarding to a part

static volatile char beat_tick = 0; // tick (i.e. vbi) count for beat, resets to zero at the start of each beat 
static volatile char mus_beat = 0; // musical beat
static volatile char mus_part = 0; // total part number
static char timestocall = 1; // how many times to call the playroutine
static volatile int totalframes = 0;

void my_isr(void) interrupt { /* THE INTERRUPT */
    DI;
    READ_VDP_STATUS;

    totalframes++;

    if (mus_fftargetpart > mus_part) timestocall = 16;
    else if (ispressed(K_3)) { if (mus_part < 3) mus_fftargetpart = 3; timestocall = 1; mus_ffingtopart = 1; }
//    else if (ispressed(K_5)) { if (mus_part < 5) mus_fftargetpart = 5; timestocall = 1; mus_ffingtopart = 1; }
//    else if (ispressed(K_7)) { if (mus_part < 7) mus_fftargetpart = 7; timestocall = 1; mus_ffingtopart = 1; }
    else if (ispressed(K_9)) { if (mus_part < 9) mus_fftargetpart = 9; timestocall = 1; mus_ffingtopart = 1; }
    else if (ispressed(K_0)) { if (mus_part < 10) mus_fftargetpart = 10; timestocall = 1; mus_ffingtopart = 1; }
    else if (ispressed(K_TAB)) { mus_fftargetpart = mus_part + 1; timestocall = 1; mus_ffingtopart = 1; }
    else if (ispressed(K_S)) timestocall=2;
    else if (ispressed(K_D)) timestocall=4;
    else if (ispressed(K_F)) timestocall=6;
    else timestocall=1;

    while (timestocall--)
    {
      PLY_Play();

        beat_tick ++;
        part_tick ++;
        if (beat_tick >= 10) { mus_beat++; beat_tick = 0; }
        switch (mus_part)
        {
            case 0: // ** hospital starting up **
                if ((!beat_tick) && ((mus_beat & 0xF) == 0)) thump++;
                if (mus_beat >= 32) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 1: // hospital starting up 2
                if ((!beat_tick) && ((mus_beat & 0xF) == 0)) thump++;
                if (mus_beat >= 32) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 2: // hospital running
                if ((!beat_tick) && (((mus_beat & 0xF) == 0) || ((mus_beat & 0xF) == 5))) thump++;
                if (mus_beat >= 32*2) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 3: // running 2...
                if ((!beat_tick) && (((mus_beat & 0x7) == 0) || ((mus_beat & 0xF) == 5))) thump++;
                if (mus_beat >= 32*2) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 4: // running 3... with some sort of bass
                if ((!beat_tick) && (((mus_beat & 0xF) == 0) || ((mus_beat & 0xF) == 5))) thump++;
                if (mus_beat >= 60) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 5: // BIG SHORT GROWL
                if (mus_beat >= 4) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 6: // quiet pretty peaceful part, no drums
                if (mus_beat >= 48) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 7: // BIG UGLY DRUMS and NOISE
                if ((!beat_tick) && (((mus_beat & 0x7) == 0) || ((mus_beat & 0x7) == 3))) thump++;
                if (mus_beat >= 32*2) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 8: // continues
                if ((!beat_tick) && (((mus_beat & 0x7) == 0) || ((mus_beat & 0x7) == 3))) thump++;
                if (mus_beat >= 32*2) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 9: // quieter middle pattern
                if ((!beat_tick) && (((mus_beat & 0xF) == 0) || ((mus_beat & 0xF) == 3))) thump++;
                if (mus_beat >= 32) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 10: // UGLY DRUMS AGAIN!
                if ((!beat_tick) && (((mus_beat & 0x7) == 0) || ((mus_beat & 0x7) == 3))) thump++;
                if (mus_beat >= 32*2) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 11: // continues, backbeat bass thing
                if ((!beat_tick) && (((mus_beat & 0x7) == 0) || ((mus_beat & 0x7) == 3))) thump++;
                if (mus_beat >= 32*2) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 12: // HIT! HIT! HIT!
                if ((!beat_tick) && ((mus_beat == 0) || (mus_beat == 3) || (mus_beat == 6))) thump++;
                if (mus_beat >= 8) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 13: // short section with drums
                if ((!beat_tick) && (((mus_beat & 0x7) == 0) || ((mus_beat & 0x7) == 3))) thump++;
                if (mus_beat >= 8) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 14: // THE END HIT!!
                if (mus_beat >= 8) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 15: // end rumble
                if (mus_beat >= 20) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

            case 16: // END, quiet
                if (mus_beat >= 8) { mus_part++; mus_beat = 0; part_tick = 0; thump = 0; }
                break;

                // when mus_part = 15, demo ENDS, no sound anymore
            default: break;
        } // switch
        if ((mus_ffingtopart) && (mus_part >= mus_fftargetpart))
        {
            mus_ffingtopart = 0;
            timestocall = 0;
        }
    } // while timestocall
    PLY_SendRegisters();
    EI;
}

void main(void)
{
    int i=0,j,k,l,
        suum=0,ohvi=0,plusa=33,swirl=0,circles=0;
    unsigned char c,sum,*p,*s,*d;
    unsigned u;
    char prevthump = 123;

    spindown();
    screen(2);

    PLY_SongPtr = (char *)0x0103;
    PLY_Init();

    // Blank
    vdp_register(VDP_COLOR,BLACK);
    vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM);

    if(isvdp2())
    {
        msx2_sethz(50);
        for(i=0;i<15;i++)
            msx2_palette(i+1,msx1[i*3+0],msx1[i*3+1],msx1[i*3+2]);
    }

    // Mess the blocks a bit
    for(i=0;i<12;i++)
        blokptn[random()&31] ^= (1<<(random()&7));

    // Calc lookups
    u=(((unsigned)lukaps)+255)&0xff00;
    lowbit=(unsigned char *)u;
    colorcyc=(unsigned char *)(u+256);
    treeshold=(unsigned char *)(u+512);

    for(i=0;i<256;i++)
    {
        lowbit[i]=(i&0xfc)+(i+1&3);

        colorcyc[i]=(i&0x1f)+(i+0x20&0xe0);
        colorcyc[i]=(colorcyc[i]&0xe3)+(i+4&0x1c);

        sum=0;
        c=i>>5;
        switch(c)
        {
            case 0: sum+=0; break;
            case 1: sum+=4; break;
            case 2: sum+=5; break;
            case 3: sum+=7; break;
            case 4: sum+=3; break;
            case 5: sum+=7; break;
            case 6: sum+=6; break;
            case 7: sum+=8; break;
        }
        c=(i>>2)&7;
        switch(c)
        {
            case 0: sum+=0; break;
            case 1: sum+=4; break;
            case 2: sum+=5; break;
            case 3: sum+=7; break;
            case 4: sum+=3; break;
            case 5: sum+=7; break;
            case 6: sum+=6; break;
            case 7: sum+=8; break;
        }

        if(sum>9)
            treeshold[i]=0xdc+(i&3);
        else
            treeshold[i]=0x18+(i&3);
    }

    for(i=0;i<32*24;i++)
    {
        texture[i]=0;
        dang[i]+=(unsigned)texture;
    }

    for(i=0;i<768+256;i++)
    {
        rantomi[i]=(i+random()+random())&3;
    }

    // Set up color table o.O
    DI;
    for(i=0;i<64;i++)
    {
        c=picpal[i>>3]+(picpal[i&7]<<4);
        for(j=0;j<32;j++)
        {
            vdp_poke(COLOR_TABLE+(i<<5)+j,c);
            vdp_poke(COLOR_TABLE+2048+(i<<5)+j,c);
            vdp_poke(COLOR_TABLE+4096+(i<<5)+j,c);
        }
    }
    EI;

    // Och pattern table x.X
    DI;
    for(i=0;i<4;i++)
    {
        p=&blokptn[i<<3];
        for(j=0;j<2048;j+=32)
        {
            vdp_address(PATTERN_TABLE+(i<<3)+j);
            vdp_copy(p,8);
            vdp_address(PATTERN_TABLE+2048+(i<<3)+j);
            vdp_copy(p,8);
            vdp_address(PATTERN_TABLE+4096+(i<<3)+j);
            vdp_copy(p,8);
        }
    }
    EI;

    // Black & unblank
    waitVB();
    vdp_address(NAME_TABLE);
    vdp_set(0,768);
    vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM+MODE1_BLANK);

    mem_set(buf1,0,768);
    d=buf1;

    // Muzak starts here
    install_isr(my_isr);

    // Main loop
    i=j=k=l=0;
    d=buf1;

    while(!space() && (mus_part < NUM_PARTS))
    {
        //// ** hospital starting up ** (part length 320 ticks)
        // Part 0: Random growing
        if(mus_part==0)
        {
            vdp_register(VDP_COLOR,((mus_beat>>1)&7)+1);

            j++;
            if(j>15)
            {
                j=0;
                p=&rantomi[random()&255];
                s=buf1;
                for(i=0;i<768;i++,p++,s++)
                    if(*p&1)
                        *s=pills[i+32*3];
                    else
                        *s^=0x1;
            }

            d=buf1;
        }

        //// ** hospital starting up 2 ** (part length 320 ticks)
        // Part 1:
        else if(mus_part==1)
        {
            vdp_register(VDP_COLOR,(((mus_beat+thump)>>1)&7)+1);

            waitVB();
            waitVB();
            rotlowbits(d);
            d=buf1;
        }

        //// ** Hospital is RUNNING there's a patient coming in ** (part length 640 ticks)
        // Part 2:
        else if(mus_part==2)
        {
            if((mus_beat)&4)
                vdp_register(VDP_COLOR,BLACK);
            else
                vdp_register(VDP_COLOR,WHITE);

            waitVB();
            waitVB();
            mem_cpy(buf1,&hospitaali[(random()&31)<<5],32*24);

            if((mus_beat&3)==0)
                threshold(buf1);

            d=buf1;
        }

        //// ** Running continues... patient is in ** (part length 640 ticks)
        // Part 3:
        else if(mus_part==3)
        {
            if(mus_beat&2)
                vdp_register(VDP_COLOR,BLACK);
            else
                vdp_register(VDP_COLOR,WHITE);

            mem_cpy(buf1,&pills[32*200-j],32*24);

            if(mus_beat&2)
                or(buf1,&mv[j>>1<<5]);

            j++;
            d=buf1;
        }

        //// ** running 3... with some sort of bass ** (part length 600 ticks)
        // Part 4:
        else if(mus_part==4)
        {
            if(mus_beat&8)
                vdp_register(VDP_COLOR,DARK_BLUE);
            else
                vdp_register(VDP_COLOR,LIGHT_BLUE);

            ohvi+=plusa;

            if(mus_beat&4)
            {
                if((mus_beat&2)==0)
                    plusa=30 + (thump & 3);
                else
                    plusa=-29;
            }
            else
            {
                if((mus_beat&2)==0)
                    plusa=37+32;
                else
                    plusa=-35-32;
            }

            mem_cpy(texture,&pills[ohvi],32*24);
            dodang(buf1,dang);
            d=buf1;
        }

        //// *** BIG SHORT GROWL *** ONE-SECOND SHOCK! (part length ONLY 40 TICKS)
        // Part 5:
        else if(mus_part==5)
        {
            waitVB();
            vdp_register(VDP_COLOR,random()&15);
            colorcycle(d);
        }

        //// ** quiet pretty PEACEFUL part, DID THE PATIENT DIE!? no drums ** (part length 480 ticks)
        // Part 6:
        else if(mus_part==6)
        {
            vdp_register(VDP_COLOR,WHITE);
            if(d==buf1)
                d=&hospitaali[188*32];
            d+=2;
            if(d==&hospitaali[188*32]+32)
                d=&hospitaali[188*32];
        }

        //// ** BIG DRUMS SHOCK! PATIENT IS STILL KICKING AND HALLUCINATING big drums ** (length 640 ticks)
        // Part 7:
        else if(mus_part==7)
        {
            d=buf1;

            if(thump&1)
            {
                mem_cpy(d,&hospitaali[95*32+part_tick+(part_tick>>1<<5)],32*24);
                vdp_register(VDP_COLOR,DARK_RED);
            }
            else
            {
                mem_cpy(d,&hospitaali[95*32-part_tick],32*24);
                vdp_register(VDP_COLOR,LIGHT_RED);
            }

            kaleido(d);
        }

        //// ** Big drums hallucination shock continues **  (length 640 ticks)
        // Part 8:
        else if(mus_part==8)
        {
            waitVB();
            vdp_register(VDP_COLOR,random()&15);

            d=texture;
            if(mus_beat&7==7)
            {
                j=13*32+(random()&7)-3;
                mem_cpy(texture,&hospitaali[j],32*24);
            }

            if(mus_beat&2)
            {
                hline(totalframes%24,0xdf);
                hline((totalframes+1)%24,4);
            }

            rotlowbits(d);
        }

        //// ** Give me a break!? QUIET middle pattern... **  (length 320 ticks)
        // Part 9:
        else if(mus_part==9)
        {
            hline((circles+4),0xf8);
            hline(circles,0);

            vline((swirl+4)&31,0xf8);
            vline(swirl,0);

            vline((swirl+20)&31,0xf8);
            vline((swirl+16)&31,0);

            swirl=(swirl+1)&31;

            mem_cpy(buf2,&hospitaali[70*32],32*24);
            dodang(buf1,dang);

            circles++;
            if(circles>=24)
                circles=0;

            or(buf1,buf2);
            d=buf1;
        }

        //// ** NO MERCY FOR THE PATIENT! ** UGLY DRUMS AGAIN!  (length 640 ticks)
        // Part 10:
        else if(mus_part==10)
        {
            waitVB();
            vdp_register(VDP_COLOR,14+(mus_beat&1));
            waitVB();
            waitVB();

            if(k==0)
                k=32*216-1;

            p=buf1;
            for(i=0;i<24;i++,p+=32)
                mem_cpy(p,&hospitaali[(i<<5)+(random()&3)+k],32);

            k-=32;

            d=buf1;
        }

        //// ** Ugggly drums continue, with a backbeat bass thing  (length 640 ticks)
        // Part 11:
        else if(mus_part==11)
        {
            waitVB();
            vdp_register(VDP_COLOR,12+(mus_beat&1));

            d=buf1;
            if(thump!=prevthump)
            {
                suumi(buf1,&pills[l],4+6*32);
                if (beat_tick >= 4) prevthump = thump;
            }
            else
            {
                mem_cpy(buf1,&pills[l],32*24);
                l+=31;
                if(l>=32*200)
                    l-=32*200;
            }
        }

        //// ** HIT! HIT! HIT! ** Trying to save the patient with ELECTRIC SHOCKS ** (part length 80 ticks)
        // Part 12:
        //// ** Very short (length 80 ticks) section with a bit more drums... **
        // Part 13:
        //// ** GAME OVER text! Patient is DEAD ** (part length 40 ticks)
        // Part 14:
        //// ** End rumble **
        // Part 15:
        else if(mus_part>=12 && mus_part<15)
        {
            waitVB();
            vdp_register(VDP_COLOR,mus_part + thump);

            d=texture;
            switch(random()%5)
            {
                case 0: rotlowbits(d); break;
                case 1: kaleido(d); break;
                case 2: threshold(d); break;
                case 3: mem_cpy(d,&hospitaali[random()&1023],32*24); break;
                case 4: mem_cpy(d,&pills[random()&1023],32*24); break;
                default: ;
            }

            if(mus_beat&2)
            {
                hline(totalframes%24,0xdf);
                hline((totalframes+1)%24,4);
            }
        }
        else
        {
            d=texture;
            vdp_register(VDP_COLOR,WHITE);
            waitVB();
            waitVB();

            mem_cpy(d,&hospitaali[(random()&7)<<5],32*24);

            hline(random()%24,0xdf);
            hline(random()%24,4);

            if((random()&7)==0)
                threshold(d);
        }

        waitVB();
        vdp_address(NAME_TABLE);
        vdp_copy(d,768);
    }

    uninstall_isr();
    PLY_Stop();
    screen(0);
}
