// A demo it is: Atoes

#include <interrupt.h>
#include <msxlib.h>
#include "ArkosTrackerPlayer_MSX.h"

extern unsigned char poika1[],poika3[],poika5[],mies1[],
					 mies2[],ukko2[],kanttuvei[];

unsigned char *pix[]={poika1,poika3,poika5,mies1,mies2,ukko2,kanttuvei};

volatile int vbicount=0;

void my_isr(void) interrupt
{
	DI;
	READ_VDP_STATUS;

	PLY_Play();
	PLY_SendRegisters();

	vbicount++;

	EI;
}

unsigned char nt1[768],nt2[768];

void main(void)
{
	int i,j,idx=0;
	unsigned char c,quit=0,page=0,phase=0,*ptr=poika1;

	spindown();
	screen(2);

	PLY_SongPtr = (char *)0x0103;
	PLY_Init();

	vdp_register(VDP_COLOR,BLACK);
	vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM);

	if(isvdp2())
	{
		msx2_sethz(50);
		msx2_palette(6,4,0,0); // Bloodier red for VDP2
	}

	// Calculate name tables for the two pages
	mem_set(nt1,0,768);
	mem_set(nt2,128,768);

	for(i=0,c=0;i<8;i++)
		for(j=0;j<16;j++,c++)
		{
			nt1[(i<<5)+j+8]=
			nt1[(i<<5)+j+8+256]=
			nt1[(i<<5)+j+8+512]=c;

			nt2[(i<<5)+j+8]=
			nt2[(i<<5)+j+8+256]=
			nt2[(i<<5)+j+8+512]=c+128;
		}

	// Various tables and their initial state
	DI;
	vdp_address(NAME_TABLE);
	vdp_slowcopy(nt1,768);
	vdp_address(PATTERN_TABLE);
	vdp_slowcopy(poika3,1024);
	vdp_address(PATTERN_TABLE+2048);
	vdp_slowcopy(poika3+1024,1024);
	vdp_address(PATTERN_TABLE+4096);
	vdp_slowcopy(poika3+2048,1024);
	vdp_address(COLOR_TABLE);
	vdp_slowset(FG_WHITE+BLACK,6*1024);
	EI;

	install_isr(my_isr);

	vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM+MODE1_BLANK);

	// Main loop
	while(!quit)
	{
		waitVB();
		//vdp_register(VDP_COLOR,RED);

#define MAIN_PART_START (465)
        
		// Begin flicker
		if(vbicount<MAIN_PART_START)
		{
			if(PLY_PSGReg8 < 1) // Yes blank
				vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM);
			else  // Show img
				vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM+MODE1_BLANK);
		}

		if(vbicount>=MAIN_PART_START && vbicount<58*50)
		{
			// Make sure not blanked initially
			if(vbicount==MAIN_PART_START)
				vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM+MODE1_BLANK);

			if(vbicount>55*50+15)
            { // end-part, show flickering skull only
				ptr=kanttuvei;

				// flicker skull
				if((random()&511)>>1<(vbicount-53*50)) // Yes blank
					vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM);
				else  // Show img
					vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM+MODE1_BLANK);
			}

			if(phase==0) // update first 1k
			{
				if(!page)
					vdp_address(PATTERN_TABLE);
				else
					vdp_address(PATTERN_TABLE+1024);
				vdp_slowcopy(ptr,1024);
			}
			if(phase==1) // and so on
			{
				if(!page)
					vdp_address(PATTERN_TABLE+2048);
				else
					vdp_address(PATTERN_TABLE+1024+2048);
				vdp_slowcopy(ptr+1024,1024);
			}
			if(phase==2)
			{
				if(!page)
					vdp_address(PATTERN_TABLE+4096);
				else
					vdp_address(PATTERN_TABLE+1024+4096);
				vdp_slowcopy(ptr+2048,1024);
			}

			// Show new page
			if(phase==3)
			{
				vdp_address(NAME_TABLE);
				if(!page)
					vdp_slowcopy(nt1,768);
				else
					vdp_slowcopy(nt2,768);
			}

#define RED_FLOOD_START (19*50-25)
            
			// Red flood
			if(vbicount>RED_FLOOD_START)
			{
				i=(vbicount-RED_FLOOD_START)>>3;
				if(i<192)
				{
					j=COLOR_TABLE+(i&7)+((i>>3)<<7);
					if(i>63)
						j+=1024;
					if(i>127)
						j+=1024;
					if(page)
						j+=1024;

					for(c=0;c<16;c++,j+=8)
						vdp_poke(j,FG_DARK_RED+BLACK);
				}
			}

			phase++;

			if(phase==5) // new image to the works
			{
				phase=0;
				idx++;
				if(idx==7)
					idx=0;
				ptr=pix[idx];
				page=1-page;
			}
		}

		if(vbicount>=58*50) {
			vdp_register(VDP_MODE1,MODE1_IE+MODE1_VRAM);
            PLY_Stop();
        }
		if(vbicount>=63*50)
			quit=1;

		if(space())
			quit=1;
		//vdp_register(VDP_COLOR,BLACK);
	}

    waitVB();
	uninstall_isr();
    PLY_Stop();
    PLY_SendRegisters();
	screen(0);
	print("L!T 2!0 years - M!arq 4!0 years\r\n");
}
